<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>:::::. NBS TECH .:::::</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link rel="icon" href="https://nbstelecom.com.br/wp-content/uploads/2020/02/cropped-logo_ico-32x32.png" sizes="32x32" />
  <link rel="icon" href="https://nbstelecom.com.br/wp-content/uploads/2020/02/cropped-logo_ico-192x192.png" sizes="192x192" />
  <link rel="apple-touch-icon-precomposed" href="https://nbstelecom.com.br/wp-content/uploads/2020/02/cropped-logo_ico-180x180.png" />
  <meta name="msapplication-TileImage" content="https://nbstelecom.com.br/wp-content/uploads/2020/02/cropped-logo_ico-270x270.png" />

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link
    href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

</head>

<body class="index-page">

  <header id="header" class="header fixed-top">

    <div class="topbar d-flex align-items-center">
      <div class="container d-flex justify-content-center justify-content-md-between">
        <div class="contact-info d-flex align-items-center">
          <i class="bi bi-envelope d-flex align-items-center"><a href="mailto:"></a></i>
          <i class="bi bi-phone d-flex align-items-center ms-4"><span></span></i>
        </div>
        <div class="social-links d-none d-md-flex align-items-center">          
          <a href="https://www.facebook.com/nbstelecom.com.br/" target="_blank" class="facebook"><i class="bi bi-facebook"></i></a>
          <a href="https://www.instagram.com/nbstelecom" target="_blank" class="instagram"><i class="bi bi-instagram"></i></a>
          <a href="https://www.linkedin.com/company/nbstelecom/" target="_blank" class="linkedin"><i class="bi bi-linkedin"></i></a>
        </div>
      </div>
    </div><!-- End Top Bar -->

    <div class="branding d-flex align-items-center">

      <div class="container position-relative d-flex align-items-center justify-content-between">
        <a href="index.php" class="logo d-flex align-items-center">
          <!-- Uncomment the line below if you also wish to use an image logo -->
          <img src="assets/img/empresas/NBS_AZUL.svg"  width="75px" height="36px" class="img-fluid" alt="NBSTECH">
        </a>

        <nav id="navmenu" class="navmenu">
          <ul>
            <li><a href="#home" class="active">Home</a></li>
            <li><a href="#palestrantes">Palestrantes</a></li>
            <li><a href="#evento">Evento 2023</a></li>
            <li><a href="#conteudo">Conteúdo</a></li>            
            <li><a href="programacao.php">Programação</a></li>
            <li><a href="#contato">Contato</a></li>
          </ul>
          <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
        </nav>
      </div>

    </div>

  </header>

  <main class="main">

   <!-- Hero Section -->
<section id="home" class="hero section d-flex flex-column align-items-center justify-content-center">
  <img src="assets/img/FUNDO01.png" alt="" data-aos="fade-in" class="position-absolute w-100 h-100">
  <div class="container text-center" data-aos="fade-up" data-aos-delay="100">
    <!-- Logo no topo -->
    <img src="assets/img/NBSTECH.png" class="logo mb-4">
    <br />
    <br />
    <br />
    <br />
    
    <!-- Conteúdo textual abaixo da logo -->
    <h2>Melhores Soluções</h2>
    <h1 style="color:#5c95cd; font-family: 'Montserrat', sans-serif; font-weight: bold; text-transform: uppercase;">tecnológicas do mundo para</h1>
    <h1 style="color:#f26b1d; font-family: 'Montserrat', sans-serif; font-weight: bold; text-transform: uppercase;">o Norte</h1>
    
    <div class="countdown d-flex justify-content-center mt-4" data-count="2024/11/13">
      <div>
        <h3 class="count-days">72</h3>
        <h4>Dias</h4>
      </div>
      <div>
        <h3 class="count-hours">5</h3>
        <h4>Horas</h4>
      </div>
      <div>
        <h3 class="count-minutes">19</h3>
        <h4>Minutos</h4>
      </div>
      <div>
        <h3 class="count-seconds">7</h3>
        <h4>Segundos</h4>
      </div>
    </div>
    
    <p style="font-size: 13px;">13 - 14 NOVEMBRO | 2024 | PRIME HOUSE JI-PARANÁ - RO</p>

    <a href="https://www.sympla.com.br/3-nbs-tech__2637065" target="_blank" class="btn-get-started mt-3">INSCREVA-SE</a>
    
  </div>
</section>
<!-- /Hero Section -->

<!-- Team Section -->
<section id="palestrantes" class="team sectionteam bg-dark text-white">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <span>PALESTRANTES</span>
    <h2 style="display: inline-block; background-color: white; padding: 10px 20px; border-radius: 5px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">PALESTRANTES</h2>
    <p>VEJA QUEM ESTARÁ NO PALCO DO NBS TECH 2024.</p>
  </div>
  <!-- End Section Title -->

  <div class="container">

    <div class="row">

      <div class="col-lg-4 col-md-6 d-flex" data-aos="fade-up" data-aos-delay="100">
        <div class="member1 bg-dark">
          <img src="assets/img/team/DANILO.png" class="img-fluid" alt="">
          <div class="member-content">
            <h4>Danilo Velloso</h4>
            <span></span>
            <p>
              Graduações nas áreas de Proc. De Dados, Bacharel em Computação com enf. em Administração de empresas,
              Gestão de Tecnologia, MBA em Gestão de Projetos pela FGV, pós graduações em compras públicas, finanças
              públicas, educação, gestão de projetos e gestão de cidades. Consultor, Professor e Palestrante nas
              áreas de Tecnologia, Administração, Gestão de Projetos e Investimentos. Consolidada carreira
              corporativa com passagem por Votorantim, Ericsson, Embraer, Confab, KDDI do Japão entre outras.
              Realizou projetos nas Américas, Europa e Ásia. Possui certificações nas áreas de tecnologia, gestão e
              governança, com prêmios internacionais conquistados, dentre eles o Benchmarking mundial de gestão de
              projetos do PMI.
            </p>
            <div class="social">              
              <a href=""><i class="bi bi-facebook"></i></a>
              <a href=""><i class="bi bi-instagram"></i></a>
              <a href=""><i class="bi bi-linkedin"></i></a>
            </div>
          </div>
        </div>
      </div><!-- End Team Member -->

      <div class="col-lg-4 col-md-6 d-flex" data-aos="fade-up" data-aos-delay="200">
        <div class="member1 bg-dark">
          <img src="assets/img/team/OSWALDO.png" class="img-fluid" alt="">
          <div class="member-content">
            <h4>Oswaldo de Freitas Alves</h4>
            <span>Gerente da GPE - Gerência de Projetos Estratégicos da DEO - Diretoria de Engenharia e Operações da
              RNP. </span>
            <p>
              A GPE é a área responsável por identificar oportunidades, articulação e negociação com ministérios que
              suportam a RNP, parceiros, patrocinadores e fornecedores, além de gerir programas e projetos
              estratégicos da organização, apoiando diretamente a Diretoria de Engenharia e Operações e a DG -
              Diretoria Geral na execução de suas iniciativas e alcance dos objetivos e resultados-chave da RNP.
            </p>
            <div class="social">              
              <a href=""><i class="bi bi-facebook"></i></a>
              <a href=""><i class="bi bi-instagram"></i></a>
              <a href=""><i class="bi bi-linkedin"></i></a>
            </div>
          </div>
        </div>
      </div><!-- End Team Member -->

      <div class="col-lg-4 col-md-6 d-flex" data-aos="fade-up" data-aos-delay="300">
        <div class="member1 bg-dark">
          <img src="assets/img/team/ALESSANDRO.png" class="img-fluid" alt="">
          <div class="member-content text-white">
            <h4>Alessandro de Oliveira Faria</h4>
            <span>Cofundador da empresa OITI TECHNOLOGIES</span>
            <p>
              Cofundador da empresa OITI TECHNOLOGIES, Autodidata, Pesquisador cujo primeiro contato com tecnologia
              foi em 1983 aos 11 anos. Leva Linux a sério desde 1998 junto com pesquisas e trabalhos em biometria e
              visão computacional. Experiência com biometria facial desde 2003, redes neurais artificiais e
              neurotecnologia desde 2009. Inventor da tecnologia CERTIFACE, mais de 200 palestras ministradas, 14
              artigos impressos publicados, mais de 9 milhões de acessos nos 120 artigos publicados no portal Viva O
              Linux, Mentor Cybersecuritygirls BR , Professor da FIA, Membro Oficial e Embaixador OpenSUSE Linux
              América Latina, Chapter Leader OWASP SP, Colunista Técnico, Opensource Committer, Membro do Conselho
              Internacional Intel, Intel Innovator, Notable Member I2AI, Innovation Ambassador Credicitrus e
              Fundador do Global openSUSE Linux Iniciativa INOVADORA.
            </p>
            <div class="social">             
              <a href=""><i class="bi bi-facebook"></i></a>
              <a href=""><i class="bi bi-instagram"></i></a>
              <a href=""><i class="bi bi-linkedin"></i></a>
            </div>
          </div>
        </div>
      </div><!-- End Team Member -->

    </div>

  </div>

</section>
<!-- /Team Section -->

    <!-- About Section -->
    <section id="evento" class="about section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>CONFIRA COMO FOI A EDIÇÃO DE 2023<br></span>
        <h2>CONFIRA COMO FOI A EDIÇÃO DE 2023<br></h2>
        <p></p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-6 order-1 order-lg-1" data-aos="fade-up" data-aos-delay="100">
            <iframe width="100%" height="350" src="https://www.youtube.com/embed/y-2JRcDOV9w?si=8KIJj3uWtp4k5tYz"
              title="YouTube video player" frameborder="0"
              allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
              referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
          </div>

          <div class="col-lg-6 order-2 order-lg-2 content" data-aos="fade-up" data-aos-delay="200">
            <h3></h3>
            <p class="fst-italic">
              NBS TECH, trouxe novidades tecnológicas, nas áreas de Redes, Segurança e Evoluções que podem ser aplicadas
              para a melhoria das Cidades de Rondônia.
            </p>
            <p class="fst-italic">
              Além da participação de parceiros da Segurança da informação e também Smart City.
            </p>
            <p class="fst-italic">
              Já em 2024 o NBS TECH será o evento líder em tecnologia do Norte do Brasil.
            </p>
            <p class="fst-italic">
              E incluirá palestras sobre Inteligência Artificial e Cidade Digital, o evento promete ser um ponto de
              encontro crucial para quem busca se envolver com as últimas tendências tecnológicas e contribuir para o
              desenvolvimento de cidades inteligentes na região.
            </p>

            <a href="https://www.sympla.com.br/3-nbs-tech__2637065" target="_blank" class="read-more">
              <span>INSCREVA-SE</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>

        </div>

      </div>

    </section>
    <!-- /About Section -->

    <!-- Services Section -->
    <section id="conteudo" class="services section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>CONTEÚDO INCOMPARÁVEL</span>
        <h2>CONTEÚDO INCOMPARÁVEL</h2>
        <p>O evento líder em tecnologia no Norte do Brasil, focado em inovação, networking e entretenimento. Explore as
          últimas inovações em Segurança da Informação, IA e Smart Cities. Conecte-se com profissionais de toda a região
          e desfrute de uma programação que combina aprendizado e diversão </p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
            <div class="service-item  position-relative">
              <div class="icon">
                <img width="28" height="28" src="https://img.icons8.com/ios/100/artificial-intelligence.png"
                  alt="artificial-intelligence" />
              </div>
              <a href="#" class="stretched-link">
                <h3>Inteligência Artificial</h3>
              </a>
              <p>Descubra as inovações sobre Inteligência Artificial e como elas estão transformando setores. Uma
                imersão essencial para quem quer estar à frente das tendências tecnológicas </p>
            </div>
          </div><!-- End Service Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
            <div class="service-item position-relative">
              <div class="icon">
                <img width="28" height="28" src="assets/img/svg/smart-city.svg">
              </div>
              <a href="#" class="stretched-link">
                <h3>Smart City</h3>
              </a>
              <p>Explore as soluções para cidades inteligentes, focando em sustentabilidade e conectividade. Aprenda com
                especialistas sobre o futuro urbano mais eficiente e habitável. </p>
            </div>
          </div><!-- End Service Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
            <div class="service-item position-relative">
              <div class="icon">
                <img width="28" height="28" src="assets/img/svg/governo.svg">
              </div>
              <a href="#" class="stretched-link">
                <h3>Tecnologia no Poder Público </h3>
              </a>
              <p>Explore como a tecnologia está modernizando a administração pública, tornando-a mais eficiente e
                acessível. Entenda as tendências que estão revolucionando a governança. </p>
            </div>
          </div><!-- End Service Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
            <div class="service-item position-relative">
              <div class="icon">
                <i class="bi bi-mic"></i>
              </div>
              <a href="#" class="stretched-link">
                <h3>Stand Up </h3>
              </a>
              <p>Encerrando com humor, nossa sessão de Stand Up oferece momentos de descontração após um dia intenso.
                Garanta boas risadas e uma experiência memoráve.</p>
              <a href="#" class="stretched-link"></a>
            </div>
          </div><!-- End Service Item -->

        </div>

      </div>

    </section>
    <!-- /Services Section -->
    

    <!-- Evento -->
    <section id="evento" class="about section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>EVENTO <br></span>
        <h2>EVENTO <br></h2>
        <p>PRIME HOUSE - JI-PARANÁ </p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-6 order-1 order-lg-1" data-aos="fade-up" data-aos-delay="100">
            <img src="assets/img/evento/FOTO_ESQUERDA.png" class="img-fluid" alt="">
          </div>

          <div class="col-lg-6 order-2 order-lg-2 content" data-aos="fade-up" data-aos-delay="200">
            <h3>NBS TECH</h3>
            <p class="fst-italic">
              O 3º NBS TECH se destaca como um marco tecnológico, ocorrendo nos dias 13 e 14 de novembro no novíssimo
              Espaço Prime House em Ji-Paraná. Este evento de dois dias será um centro de conhecimento e inovação,
              apresentando palestras inspiradoras e stands das principais empresas de tecnologia que atuam no Norte do
              Brasil.
            </p>

            <a href="https://www.sympla.com.br/3-nbs-tech__2637065" target="_blank" class="read-more"><span>INSCREVA-SE</span><i class="bi bi-arrow-right"></i></a>
          </div>

        </div>

      </div>

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>PARTICIPAÇÃO E ESTRUTURA <br></span>
        <h2>PARTICIPAÇÃO E ESTRUTURA <br></h2>
        <p>INOVAÇÃO E NETWORKING </p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-6 order-1 order-lg-2" data-aos="fade-up" data-aos-delay="100">
            <img src="assets/img/evento/FOTO_DIREITA.png" class="img-fluid" alt="">
          </div>

          <div class="col-lg-6 order-2 order-lg-1 content" data-aos="fade-up" data-aos-delay="200">
            <h3></h3>
            <p class="fst-italic">
              Esperamos receber cerca de 300 participantes, incluindo profissionais técnicos e autoridades de Rondônia,
              Acre e demais estados do Norte, proporcionando uma experiência única de networking e aprendizado. O local
              contará com uma dinâmica de alimentação interativa, garantindo conforto, conveniência aos visitantes.
            </p>
            <h3>DESTAQUES</h3>
            <p>
              Com palestrantes renomados e as maiores empresas de tecnologia do país expondo suas inovações, o NBS TECH
              é o encontro ideal para quem busca estar na vanguarda do setor tecnológico.
            </p>

            <a href="https://www.sympla.com.br/3-nbs-tech__2637065" target="_blank" class="read-more"><span>INSCREVA-SE</span><i class="bi bi-arrow-right"></i></a>
          </div>

        </div>

      </div>

    </section><!-- /EVENTO -->


    <!-- Clients Section -->
    <section id="clients" class="clients section light-background">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>Parceiros Conectados</span>
        <h2>Parceiros Conectados</h2>
        <p></p>
      </div>
      <!-- End Section Title -->

      <div class="container">

        <div class="swiper init-swiper">
          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 600,
              "autoplay": {
                "delay": 5000
              },
              "slidesPerView": "auto",
              "pagination": {
                "el": ".swiper-pagination",
                "type": "bullets",
                "clickable": true
              },
              "breakpoints": {
                "320": {
                  "slidesPerView": 2,
                  "spaceBetween": 40
                },
                "480": {
                  "slidesPerView": 3,
                  "spaceBetween": 60
                },
                "640": {
                  "slidesPerView": 4,
                  "spaceBetween": 80
                },
                "992": {
                  "slidesPerView": 6,
                  "spaceBetween": 120
                }
              }
            }
          </script>
          <div class="swiper-wrapper align-items-center">
            <div class="swiper-slide"><img src="assets/img/empresas/CLEARIT.svg" class="img-fluid" alt="CLEARIT"></div>
            <div class="swiper-slide"><img src="assets/img/empresas/CREDISIS.svg" class="img-fluid" alt="CREDISIS"></div>
            <div class="swiper-slide"><img src="assets/img/empresas/FORTINET.svg" class="img-fluid" alt="FORTINET"></div>
            <div class="swiper-slide"><img src="assets/img/empresas/MULTI_ZTE.svg" class="img-fluid" alt="MULTI_ZTE"></div>            
            <div class="swiper-slide"><img src="assets/img/empresas/INTELBRAS.svg" class="img-fluid" alt="INTELBRAS"></div>
            <div class="swiper-slide"><img src="assets/img/empresas/SYNNEX.svg" class="img-fluid" alt="SYNNEX"></div>
          </div>
        </div>

      </div>

    </section><!-- /Clients Section -->



    <!-- Call To Action Section -->
    <section id="call-to-action" class="call-to-action section dark-background">

      <img src="assets/img/FUNDO02.png" alt="">

      <div class="container">
        <div class="row justify-content-center" data-aos="zoom-in" data-aos-delay="100">
          <div class="col-xl-10">
            <div class="text-center">
              <h3>NBS TECH</h3>
              <p></p>
              <a class="cta-btn" href="https://www.sympla.com.br/3-nbs-tech__2637065" target="_blank">INSCREVA-SE</a>
            </div>
          </div>
        </div>
      </div>

    </section><!-- /Call To Action Section -->


    <!-- Contact Section -->
    <section id="contato" class="contact section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span>Contato</span>
        <h2>Contato</h2>
        <p></p>
      </div><!-- End Section Title -->

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-4">

          <div class="col-lg-6">
            <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up"
              data-aos-delay="200">
              <i class="bi bi-geo-alt"></i>
              <h3>Endereço</h3>
              <p>Av. Mal. Rondon, 134 - União, Ji-Paraná - RO, 76900-003</p>
            </div>
          </div><!-- End Info Item -->

          

          <div class="col-lg-3 col-md-6">
            <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up"
              data-aos-delay="400">
              <i class="bi bi-envelope"></i>
              <h3>Email</h3>
              <p>contato@nbs-tech.com</p>
            </div>
          </div><!-- End Info Item -->

        </div>

        <div class="row gy-4 mt-1">
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="300">
            <iframe
              src="https://maps.google.com/maps?q=Av.%20Marechal%20Rondon%2C%20134%20%E2%80%93%20Bairro%20Centro%20de%20Ji-Paran%C3%A1%20%E2%80%93%20RO&t=m&z=16&output=embed&iwloc=near"
              frameborder="0" style="border:0; width: 100%; height: 400px;" allowfullscreen="" loading="lazy"
              referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div><!-- End Google Maps -->

          <div class="col-lg-6">
            <form action="forms/contact.php" method="post" class="php-email-form" data-aos="fade-up"
              data-aos-delay="400">
              <div class="row gy-4">

                <div class="col-md-6">
                  <input type="text" name="name" class="form-control" placeholder="Nome" required="">
                </div>

                <div class="col-md-6 ">
                  <input type="email" class="form-control" name="email" placeholder="Email" required="">
                </div>

                <div class="col-md-12">
                  <input type="text" class="form-control" name="subject" placeholder="Assunto" required="">
                </div>

                <div class="col-md-12">
                  <textarea class="form-control" name="message" rows="6" placeholder="Mensagem" required=""></textarea>
                </div>

                <div class="col-md-12 text-center">
                  <div class="loading">Carregando...</div>

                  <div class="error-message"></div>
                  <div class="sent-message">Sua mensagem foi enviada com sucesso. Obrigado!</div>

                  <button type="submit">Enviar Mensagem</button>
                </div>

              </div>
            </form>
          </div><!-- End Contact Form -->

        </div>

      </div>

    </section><!-- /Contact Section -->

  </main>

  <footer id="footer" class="footer position-relative dark-background">

    <div class="container footer-top">
      <div class="row gy-4">
        <div class="col-lg-4 col-md-6">
          <div class="footer-about">
            <a href="index.php" class="logo sitename">
              <img src="assets/img/empresas/NBS_AZUL.svg" width="296px" height="126px" class="img-fluid" alt="NBSTECH">
            </a>
            <div class="footer-contact pt-3">
              <p></p>
              <p></p>
              
              <p><strong>Email: </strong><span>contato@nbs-tech.com</span></p>
            </div>
            <div class="social-links d-flex mt-4">              
              <a href="https://www.facebook.com/nbstelecom.com.br/" target="_blank" class="facebook"><i class="bi bi-facebook"></i></a>
              <a href="https://www.instagram.com/nbstelecom" target="_blank" class="instagram"><i class="bi bi-instagram"></i></a>
              <a href="https://www.linkedin.com/company/nbstelecom/" target="_blank" class="linkedin"><i class="bi bi-linkedin"></i></a>
            </div>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Links</h4>
          <ul>
            <li><a href="#">Home</a></li>
            <li><a href="#">Evento 2023</a></li>
            <li><a href="#">Conteúdo</a></li>
            <li><a href="#">Palestrantes</a></li>
            <li><a href="#">Contato</a></li>
          </ul>
        </div>

        <div class="col-lg-2 col-md-3 footer-links">
          <h4>Serviços</h4>
          <ul>
            <li><a href="#"></a></li>
            <li><a href="#"></a></li>
            <li><a href="#"></a></li>
            <li><a href="#"></a></li>
            <li><a href="#"></a></li>
          </ul>
        </div>
        
        <script src="forms/newsletter-form.js"></script>
        <div class="col-lg-4 col-md-12 footer-newsletter">
          <h4>Newsletter</h4>
          <p>Increva-se na nossa newsletter e receba as últimas novidades sobre nossos produtos e serviços!</p>          
          <form  id="newsletter-form" class="php-email-form">
              <div class="newsletter-form">
                  <input type="email" name="email" required>
                  <input type="submit" value="Inscreva-se">
              </div>
              <div class="loading">Carregando...</div>
              <div class="error-message"></div>
              <div class="sent-message">Sua inscrição foi enviada. Obrigado!</div>
          </form>
        </div>

      </div>
    </div>

    <div class="container copyright text-center mt-4">
      <p>© <span>Copyright</span> <strong class="px-1 sitename">DecoyTech</strong> <span>All Rights Reserved</span></p>
      <div class="credits">

      </div>
    </div>

  </footer>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i
      class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
  <script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>