<?php
// Configurações do banco de dados
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "nbslp";

// Conectar ao banco de dados
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Função para limpar e validar o e-mail
function clean_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Processar o formulário quando enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = clean_input($_POST["email"]);

    // Validar e-mail
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(["error" => "Formato de e-mail inválido"]);
        exit();
    }

    // Verificar se o e-mail já está cadastrado
    $stmt = $conn->prepare("SELECT id FROM newsletter_subscribers WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        // E-mail já cadastrado
        echo json_encode(["error" => "Este e-mail já possui um cadastro ativo."]);
    } else {
        // E-mail não cadastrado, proceder com a inserção
        $stmt->close();
        $stmt = $conn->prepare("INSERT INTO newsletter_subscribers (email) VALUES (?)");
        $stmt->bind_param("s", $email);

        if ($stmt->execute()) {
            echo json_encode(["success" => "Sua inscrição foi enviada com sucesso. Obrigado!"]);
        } else {
            echo json_encode(["error" => "Ocorreu um erro ao processar sua inscrição. Por favor, tente novamente."]);
        }
    }

    $stmt->close();
} else {
    echo json_encode(["error" => "Método de requisição inválido"]);
}

$conn->close();
?>
