document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('newsletter-form');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault(); // Impede o envio tradicional do formulário
        
        const formData = new FormData(form);
        const loadingElement = form.querySelector('.loading');
        const errorElement = form.querySelector('.error-message');
        const sentElement = form.querySelector('.sent-message');
        
        // Mostrar loading e esconder outras mensagens
        loadingElement.style.display = 'block';
        errorElement.style.display = 'none';
        sentElement.style.display = 'none';

        fetch('forms/newsletter.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            loadingElement.style.display = 'none';
            
            if(data.success) {
                sentElement.textContent = data.success;
                sentElement.style.display = 'block';
                form.reset();
            } else if(data.error) {
                errorElement.textContent = data.error;
                errorElement.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            loadingElement.style.display = 'none';
            errorElement.textContent = 'Ocorreu um erro. Por favor, tente novamente.';
            errorElement.style.display = 'block';
        })
        .finally(() => {
            loadingElement.style.display = 'none';
        });
    });
});