document.querySelector('.php-email-form').addEventListener('submit', function(e) {
  e.preventDefault(); // Impede o envio normal do formulário
  var form = this;
  var formData = new FormData(this);

  form.querySelector('.loading').style.display = 'block';
  form.querySelector('.error-message').style.display = 'none';
  form.querySelector('.sent-message').style.display = 'none';

  // Use Fetch API para enviar o formulário
  fetch(this.action, {
      method: 'POST',
      body: formData
  })
  .then(response => response.json())  // Recebe a resposta como JSON
  .then(data => {
      if (data.status === 'success') {
          // Exibe a mensagem de sucesso
          document.querySelector('.sent-message').innerHTML = data.message;
          document.querySelector('.sent-message').style.display = 'block';
          document.querySelector('.error-message').style.display = 'none';
          
          // Limpa o formulário
          document.querySelector('.php-email-form').reset();
      } else {
          // Exibe a mensagem de erro
          document.querySelector('.error-message').innerHTML = data.message;
          document.querySelector('.error-message').style.display = 'block';
          document.querySelector('.sent-message').style.display = 'none';
      }
  })
  .catch(error => {
      // Exibe uma mensagem de erro genérica se a submissão falhar
      document.querySelector('.error-message').innerHTML = 'Erro ao enviar a mensagem. Tente novamente.';
      document.querySelector('.error-message').style.display = 'block';
  })
  .finally(() => {
    // Garantir que o loading seja escondido em qualquer cenário
    form.querySelector('.loading').style.display = 'none';
  });
});
